
# script_zpush_desc()
sub script_zpush_desc
{
return "Z-push";
}

sub script_zpush_uses
{
return ( "php", "apache" );
}

sub script_zpush_longdesc
{
return "An implementation of Microsoft's ActiveSync protocol which is used 'over-the-air' for multi platform active sync devices.";
}

# script_zpush_versions()
sub script_zpush_versions
{
return ( "2.1.1-1788" );
}

sub script_zpush_release
{
return 2;	# So that 2.0.6-1616 takes priority over 2.0-1346
}

sub script_zpush_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($sinfo->{'version'} < 2 && $newver >= 2) {
	return 0;
	}
return 1;
}

sub script_zpush_category
{
return "Email";
}

sub script_zpush_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
$mode eq "mod_php" ||
	push(@rv, "Z-push requires that PHP scripts be executed using mod_php");
return @rv;
}

sub script_zpush_php_vars
{
return ( [ 'magic_quotes_gpc', 'off' ],
	 [ 'register_globals', 'off' ],
	 [ 'magic_quotes_runtime', 'off' ],
	 [ 'short_open_tag', 'on' ] );
}

sub script_zpush_php_modules
{
return ("imap");
}

sub script_zpush_php_vers
{
local ($d, $ver) = @_;
return ( 5 );
}

# script_zpush_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_zpush_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
		     &ui_textbox("dir", &substitute_scriptname_template("z-push", $d), 30));
	}
return $rv;
}

# script_zpush_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_zpush_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => "/$in{'dir'}", };
	}
}

# script_zpush_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_zpush_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Z-push appears to be already installed in the selected directory";
	}
return undef;
}

# script_zpush_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Twiki, each of which is a hash ref
# containing a name, filename and URL
sub script_zpush_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $nver = $ver;
$nver =~ s/^([0-9]+\.[0-9]+).*/$1/;
local @files = ( { 'name' => "source",
	   'file' => "z-push-$ver.tar.gz",
	   'url' => "http://zarafa-deutschland.de/z-push-download/final/$nver/z-push-$ver.tar.gz" } );
return @files;
}

sub script_zpush_commands
{
return ("tar", "gunzip");
}

# script_zpush_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_zpush_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "z-push-$ver");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Edit the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /define\('BACKEND_PROVIDER'/) {
			$l = "define('BACKEND_PROVIDER', 'BackendIMAP');";
			}
		elsif ($l =~ /define\('STATE_DIR'/) {
			$l = "define('STATE_DIR', '$opts->{'dir'}/state/');";
			}
		elsif ($l =~ /define\('LOGFILEDIR'/) {
			$l = "define('LOGFILEDIR', '$opts->{'dir'}/logs/');";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

# Make the state and logs directory writable
foreach my $dir ("state", "logs") {
	if (!-d "$opts->{'dir'}/$dir") {
		&make_dir_as_domain_user($d, "$opts->{'dir'}/$dir", 0777);
		}
	&make_file_php_writable($d, "$opts->{'dir'}/$dir");
	}

# Alias /Microsoft-Server-ActiveSync to index.php
&require_apache();
local $conf = &apache::get_config();
local @ports;
push(@ports, $d->{'web_port'}) if ($d->{'web'});
push(@ports, $d->{'web_sslport'}) if ($d->{'ssl'});
foreach my $port (@ports) {
	local ($virt, $vconf) = &get_apache_virtual($d->{'dom'}, $port);
	next if (!$virt);
	local @als = &apache::find_directive("Alias", $vconf);
	local ($al) = grep { $_ =~ /^\/Microsoft-Server-ActiveSync\s/ } @als;
	if (!$al) {
		push(@als, "/Microsoft-Server-ActiveSync $opts->{'dir'}/index.php");
		&apache::save_directive("Alias", \@als, $vconf, $conf);
		&flush_file_lines($virt->{'file'});
		}
	}
&register_post_action(\&restart_apache);

local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Z-push installation complete. It can only be used by mobile devices syncing email from this virtual server.", "Under $rp", $url);
}

# script_zpush_uninstall(&domain, version, &opts)
# Un-installs a Twiki installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_zpush_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove Apache config entry for /Microsoft-Server-ActiveSync
&require_apache();
local $conf = &apache::get_config();
local @ports;
push(@ports, $d->{'web_port'}) if ($d->{'web'});
push(@ports, $d->{'web_sslport'}) if ($d->{'ssl'});
foreach my $port (@ports) {
	local ($virt, $vconf) = &get_apache_virtual($d->{'dom'}, $port);
	next if (!$virt);
	local @als = &apache::find_directive("Alias", $vconf);
	local ($al) = grep { $_ =~ /^\/Microsoft-Server-ActiveSync\s/ } @als;
	if ($al) {
		@als = grep { $_ ne $al } @als;
		&apache::save_directive("Alias", \@als, $vconf, $conf);
		&flush_file_lines($virt->{'file'});
		}
	}
&register_post_action(\&restart_apache);

return (1, "Z-push directory deleted.");
}

# script_zpush_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_zpush_latest
{
return ( "http://z-push.org/?page_id=28",
	 "z-push-([0-9a\\.\\-]+).(txt)" );
}

sub script_zpush_site
{
return 'http://z-push.sourceforge.net/';
}

1;

