
# script_zencart_desc()
sub script_zencart_desc
{
return "ZenCart";
}

sub script_zencart_uses
{
return ( "php" );
}

sub script_zencart_longdesc
{
return "Zen Cart is a free, user-friendly, open source shopping cart system.";
}

# script_zencart_versions()
sub script_zencart_versions
{
return ( "1.5.1", "1.3.9h" );
}

sub script_zencart_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 1.5 && $sinfo->{'version'} < 1.5) {
	# Cannot upgrade 1.3 to 1.5
	return 0;
	}
return 1;
}

sub script_zencart_category
{
return "Commerce";
}

sub script_zencart_php_vers
{
return ( 5 );
}

# script_zencart_depends(&domain, version)
sub script_zencart_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.2.14
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif (&compare_versions($phpv, "5.2.14") < 0) {
	push(@rv, "ZenCart requires PHP version 5.2.14 or later");
	}

return @rv;
}

sub script_zencart_php_modules
{
return ("mysql", "curl");
}

sub script_zencart_dbs
{
return ("mysql");
}

# script_zencart_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing ZenCart
sub script_zencart_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("zencart", $d), 30, "At top level"));
	}
return $rv;
}

# script_zencart_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_zencart_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_zencart_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_zencart_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/includes/configure.php") {
	return "ZenCart appears to be already installed in the selected directory";
	}
return undef;
}

# script_zencart_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Zencart, each of which is a hash ref
# containing a name, filename and URL
sub script_zencart_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $patch_base = "http://scripts.virtualmin.com/zencart";
local %vmap = ( "1.5.1" => "09182012",
		"1.3.9h" => "10262010" );
local $source = { 'name' => "source",
		  'file' => "zen-cart-v$ver-full-fileset.zip",
		  'url' => "http://downloads.sourceforge.net/zencart/zen-cart-v$ver-full-fileset-$vmap{$ver}.zip",
		};
local @files = ( $source );
if ($ver eq "1.3.8" || $ver eq "1.3.8a") {
	push(@files, 
	    { 'name' => "patch0",
	      'file' => "admin_security_patch_v138.zip",
	      'url' => "$patch_base/admin_security_patch_v138.zip" },
	    { 'name' => "patch1",
	      'file' => "security_patch_v138_20080919.php.zip",
	      'url' => "$patch_base/security_patch_v138_20080919.php.zip" },
	    );
	}
return @files;
}

sub script_zencart_commands
{
return ("unzip");
}

# script_zencart_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs ZenCart, and returns either 1 and an informational
# message, or 0 and an error
sub script_zencart_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
	$opts->{'dir'}, "zen-cart-v*-full-*-*/");
$err && return (0, "Failed to extract source : $err");

# Extract admin patch
if ($files->{'patch0'}) {
	local $temp0 = &transname();
	local $err = &extract_script_archive($files->{'patch0'}, $temp0, $d,
		$opts->{'dir'}, "admin_security_patch_138");
	$err && return (0, "Failed to extract first patch : $err");
	}

# Extract SQL injection patch
if ($files->{'patch1'}) {
	local $temp1 = &transname();
	local $err = &extract_script_archive($files->{'patch1'}, $temp1, $d,
		$opts->{'dir'}."/includes/extra_configures");
	$err && return (0, "Failed to extract second patch : $err");
	}

# Set write permissions on needed files
local $dir;
foreach $dir ("cache", "pub", "images",
	    "includes/languages/english/html_includes", "admin/backups",
	    "admin/images/graphs",
	    "admin/includes", "includes") {
	&make_file_php_writable($d, "$opts->{'dir'}/$dir");
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Go to <a target=_blank href='$url'>$url</a> to complete the ZenCart installation process.", "Under $rp", $url);
}

# script_zencart_uninstall(&domain, version, &opts)
# Un-installs a Zencart installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_zencart_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "ZenCart directory deleted. Any database tables must be removed manually.");
}

# script_zencart_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_zencart_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions(
	"zencart", "zen-cart-v([0-9\\.]+[a-z]?)-full-fileset-\\d+\\.zip");
if ($ver < 1.5) {
	@vers = grep { $_ < 1.5 } @vers;
	}
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_zencart_site
{
return 'http://www.zencart.com/';
}

1;

