
# script_wpmu_desc()
sub script_wpmu_desc
{
return "WordPress MU";
}

sub script_wpmu_disabled
{
return 1;	# Subsumed into regular wordpress 3.0
}

sub script_wpmu_uses
{
return ( "php" );
}

sub script_wpmu_longdesc
{
return "The multi-user version of the WordPress blog engine.";
}

# script_wpmu_versions()
sub script_wpmu_versions
{
return ( "3.9.1" );
}

sub script_wpmu_category
{
return "Blog";
}

sub script_wpmu_php_vers
{
local ($d, $ver) = @_;
if ($ver >= 3.2) {
	return ( 5 );
	}
else {
	return ( 4, 5 );
	}
}

sub script_wpmu_php_modules
{
return ("mysql");
}

sub script_wpmu_dbs
{
return ("mysql");
}

# script_wpmu_depends(&domain, version)
sub script_wpmu_depends
{
local ($d, $ver) = @_;
local @rv;
&require_mysql();
if (&mysql::get_mysql_version() < 4) {
	push(@rv, "WordPress MU requires MySQL version 4 or higher");
	}
return @rv;
}

# script_wpmu_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_wpmu_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for WordPress MU tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for WordPress MU tables",
		     &ui_database_select("db", undef, \@dbs, $d, "wpmu"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("wpmu", $d), 30, "At top level"));
	if (&get_domain_web_star($d)) {
		$rv .= &ui_table_row("Blog URL type",
		  &ui_radio("star", 0, [ [ 1, "<i>blog</i>.$d->{'dom'}" ],
				         [ 0, "$d->{'dom'}/<i>blog</i>" ] ]));
		}
	}
return $rv;
}

# script_wpmu_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_wpmu_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	if ($in->{'star'} && !$in->{'dir_def'}) {
		return "The <i>blog</i>.$d->{'dom'} URL type cannot be used ".
		       "unless WPMU is installed at the top level";
		}
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'star' => $in->{'star'},
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_wpmu_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_wpmu_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/wp-login.php") {
	return "WordPress MU appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "wp_.*");
$clash && return "WordPress MU appears to be already using the selected database (table $clash)";
return undef;
}

# script_wpmu_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_wpmu_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
		   'file' => "wpmu-$ver.zip",
		   'url' => "http://mu.wordpress.org/latest.zip",
		   'virtualmin' => 1,
		   'nocache' => 1 } );
return @files;
}

sub script_wpmu_commands
{
return ("unzip");
}

# script_wpmu_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs WordPress MU, and returns either 1 and an informational
# message, or 0 and an error
sub script_wpmu_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve the old config file
local $cfile = "$opts->{'dir'}/wp-config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $verdir = $ver >= 3 ? "wordpress" : "wordpress-mu*";
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, $verdir);
$err && return (0, "Failed to extract source : $err");

if ($upgrade) {
	# Put back the config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Call the installer URL
	&make_file_php_writable($d, $opts->{'dir'}, 1);
	&make_file_php_writable($d, "$opts->{'dir'}/wp-content", 1);
	&make_file_php_writable($d, $cfile);
	local @params = (
		[ "action", "step2" ],
		[ "vhost", $opts->{'star'} ? "yes" : "no" ],
		[ "dbname", $dbname ],
		[ "uname", $dbuser ],
		[ "pwd", $dbpass ],
		[ "dbhost", $dbhost ],
		[ "basedomain", $d->{'dom'} ],
		[ "weblog_title", $d->{'owner'} ],
		[ "email", $d->{'emailto_addr'} ],
		[ "submit", "Submit" ]
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "WordPress MU database configuration failed : $ierror");
		}
	elsif ($iout !~ /password\s+"(\S+)"/i &&
	       $iout !~ /username\s+"\S+"\s+and\s+password\s+([^<> ]+)/i) {
		return (-1, "WordPress MU database configuration failed");
		}
	$opts->{'wpmu_pass'} = $1;

	# Fix up $base in config file
	local $path = $opts->{'path'};
	$path .= "/" if ($path !~ /\/$/);
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*\$base\s*=/) {
			$l = "\$base = '$path';";
			}
		if ($l =~ /^\s*define\('PATH_CURRENT_SITE',\s+'\/\/'\s+\);\s*$/) {
			# Fix up //
			$l = "define('PATH_CURRENT_SITE', '/' );";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $adminurl = $url."wp-admin/";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "WordPress MU installation complete. It can be managed at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url, "admin", $opts->{'wpmu_pass'});
}

# script_wpmu_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_wpmu_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all wp_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "wp_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "WordPress MU directory and tables deleted.");
}

# Latest wpmu is the same as latest wordpress
sub script_wpmu_latest
{
local ($ver) = @_;
return ( "http://wordpress.org/download/",
	 "Version\\s+([0-9\\.]+)" );
}

sub script_wpmu_site
{
return 'http://mu.wordpress.org/';
}

1;

