
@typo3_tables = qw(be_groups be_sessions be_users cache_extensions cache_hash cache_imagesizes cache_md5params cache_pages cache_pagesection cache_typo3temp_log fe_groups fe_session_data fe_sessions fe_users pages pages_language_overlay static_template static_tsconfig_help sys_be_shortcuts sys_domain sys_filemounts sys_history sys_language sys_lockedrecords sys_log sys_note sys_preview sys_refindex sys_refindex_rel sys_refindex_res sys_refindex_words sys_template sys_workspace tt_content tx_impexp_presets tx_rtehtmlarea_acronym cache_treelist cachingframework_cache_hash cachingframework_cache_hash_tags cachingframework_cache_pages cachingframework_cache_pages_tags cachingframework_cache_pagesection cachingframework_cache_pagesection_tags sys_registry backend_layout cf_cache_hash cf_cache_hash_tags cf_cache_pages cf_cache_pages_tags cf_cache_pagesection cf_cache_pagesection_tags sys_news sys_ter tx_rsaauth_keys);

# script_typo3_desc()
sub script_typo3_desc
{
return "Typo3 CMS";
}

sub script_typo3_uses
{
return ( "php" );
}

sub script_typo3_longdesc
{
return "TYPO3 is a free Open Source content management system for enterprise purposes on the web and in intranets.";
}

# script_typo3_versions()
sub script_typo3_versions
{
return ( "4.6.18" );
}

sub script_typo3_category
{
return "Content Management System";
}

sub script_typo3_php_vers
{
return ( 5 );
}

sub script_typo3_php_modules
{
return ("mysql", "gd");
}

sub script_typo3_dbs
{
return ("mysql");
}

sub script_typo3_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.3+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif ($phpv < 5.3) {
	push(@rv, "Typo3 requires PHP version 5.3 or later");
	}

return @rv;
}

# script_typo3_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Typo3 CMS
sub script_typo3_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Typo3 CMS tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Typo3 CMS tables",
		     &ui_database_select("db", undef, \@dbs, $d, "typo3"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("typo3", $d), 30, "At top level"));
	}
return $rv;
}

# script_typo3_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_typo3_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_typo3_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_typo3_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/typo3conf/localconf.php") {
	return "Typo3 CMS appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
foreach my $t (@typo3_tables) {
	local $clash = &find_database_table($dbtype, $dbname, $t);
	$clash && return "Typo3 CMS appears to be already using the selected database (table $clash)";
	}
return undef;
}

# script_typo3_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Typo3 CMS, each of which is a hash ref
# containing a name, filename and URL
sub script_typo3_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
		   'file' => "typo3_src-$ver.tar.gz",
		   'url' => "http://prdownloads.sourceforge.net/typo3/".
			    "typo3_src-$ver.tar.gz" } );
if (!$upgrade) {
	push(@files, { 'name' => 'dummy',
		       'file' => "dummy-$ver.tar.gz",
		       'url' => "http://prdownloads.sourceforge.net/typo3/".
				"dummy-$ver.tar.gz" });
	}
return @files;
}

sub script_typo3_commands
{
return ("tar", "gunzip", "wget");
}

# script_typo3_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Typo3 CMS, and returns either 1 and an informational
# message, or 0 and an error
sub script_typo3_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/typo3conf/localconf.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "typo3_src-$ver");
$err && return (0, "Failed to extract source : $err");

# Also extract the dummy files, if available
if ($files->{'dummy'}) {
	local $dtemp = &transname();
	local $err = &extract_script_archive($files->{'dummy'}, $dtemp, $d,
                                     $opts->{'dir'}, "dummy-$ver", 0, 0,
				     [ 'index.php', 'typo_src', 't3lib',
				       'typo3' ]);
	$err && return (0, "Failed to extract dummy site files : $err");
	}

# Make files and sub-directories writable
foreach my $dir ("fileadmin", "typo3conf", "typo3temp", "uploads") {
	&make_file_php_writable($d, "$opts->{'dir'}/$dir");
	}

local $url = &script_path_url($d, $opts);

# Create flag file to enable installer
local $iflag = "$opts->{'dir'}/typo3conf/ENABLE_INSTALL_TOOL";
&open_tempfile_as_domain_user($d, IFLAG, ">$iflag", 0, 1);
&close_tempfile_as_domain_user($d, IFLAG);
push(@main::temporary_files, $iflag);

if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Make localconf.php writable
	&make_file_php_writable($d, $cfile);

	# Request the intro page, to get the cookie
	local ($iout, $ierror);
	$installtool_cookie = undef;
	&get_http_connection($d, $opts->{'path'}."/typo3/install/index.php?mode=123&step=1&password=joh316", \$iout, \$ierror, \&typo_cookie_callback);
	if ($ierror) {
		return (-1, "Intro page failed : $ierror");
		}
	if (!$installtool_cookie) {
		return (-1, "Failed to get cookie from initial page");
		}
	local %cooks = (
		'Cookie' => "Typo3InstallTool=$installtool_cookie;"
		);

	# Request the initial form, to get the key
	local @params = ( [ 'step', 2 ] );
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/typo3/install/index.php?TYPO3_INSTALL[type]=config&mode=123&step=1";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%cooks);
	if ($ierror) {
		return (-1, "Initial page failed : $ierror");
		}
	elsif ($iout !~ /encryptionKey\]"\s+value="([^"]+)"/i &&
	       $iout !~ /value="([^"]+)".*encryptionKey\]"/i) {
		return (-1, "Failed to get encryption key from initial page");
		}
	local $ekey = $1;

	# Call DB login page
	local @params = ( [ 'TYPO3_INSTALL[localconf.php][typo_db_driver]',
			    'mysql' ],
			  [ 'TYPO3_INSTALL[localconf.php][typo_db_username]',
			    $dbuser ],
			  [ 'TYPO3_INSTALL[localconf.php][typo_db_password]',
			    $dbpass ],
			  [ 'TYPO3_INSTALL[localconf.php][typo_db_host]',
			    $dbhost ],
			  [ 'TYPO3_INSTALL[localconf.php][encryptionKey]',
			    $ekey ],
			  [ 'TYPO3_INSTALL[localconf.php][compat_version]',
			    '4.6' ],
			  [ 'step', 3 ],
		        );
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/typo3/install/index.php?".
		       "TYPO3_INSTALL[type]=config&mode=123&step=2";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%cooks);
	if ($ierror) {
		return (-1, "Database login configuration failed : $ierror");
		}
	elsif ($iout !~ /Database/i) {
		return (-1, "Database login configuration failed");
		}

	# Call the DB selection page
	local @params = ( [ 'TYPO3_INSTALL[localconf.php][typo_db]',
			    $dbname ],
			  [ 'TYPO3_INSTALL[db_select_option]', 'EXISTING' ],
			  [ 'step', 4 ],
			);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/typo3/install/index.php?".
		       "TYPO3_INSTALL[type]=config&mode=123&step=3";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%cooks);
	if ($ierror) {
		return (-1, "Database configuration failed : $ierror");
		}
	elsif ($iout !~ /Import\s+the\s+database/i) {
		return (-1, "Database configuration failed");
		}

	# Call the DB import page
	local @params = ( [ 'TYPO3_INSTALL[database_type]',
			    'import' ],
			  [ 'TYPO3_INSTALL[database_import_all]', 1 ],
			  [ 'step', '' ],
			  [ 'goto_step', 'go' ],
			  [ 'TYPO3_INSTALL[database_type]',
			    'import|CURRENT_TABLES+STATIC' ],
			);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/typo3/install/index.php?".
		       "TYPO3_INSTALL[type]=database&mode=123&step=4";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%cooks);
	if ($ierror) {
		return (-1, "Database import failed : $ierror");
		}
	}

# Remove installer flag file and install folder
&unlink_file_as_domain_user($d, $iflag);

SKIP:

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."typo3";
return (1, "Initial Typo3 CMS installation complete. Go to <a target=_blank href='$adminurl'>$adminurl</a> to manage it.", "Under $rp using $dbtype database $dbname", $url, "admin", "password");
}

# script_typo3_uninstall(&domain, version, &opts)
# Un-installs a Typo3 CMS installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_typo3_uninstall
{
local ($d, $version, $opts) = @_;

# Remove typo3 tables from the database
local $err = &cleanup_script_database($d, $opts->{'db'}, \@typo3_tables);

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted Typo3 CMS directory and tables.");
}

# script_typo3_check_latest(version)
sub script_typo3_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("typo3",
				     "typo3_src-([0-9\\.]+)\\.tar\\.gz");
@vers = grep { !/^4\.7\.[0-9]+/ &&
	       !/^[5-9]\./ } @vers;
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_typo3_site
{
return 'http://www.typo3.com/';
}

sub typo_cookie_callback
{
foreach my $h (@WebminCore::headers) {
	if (lc($h->[0]) eq 'set-cookie' &&
	   $h->[1] =~ /Typo3InstallTool_key=([^;]+)/i) {
		$installtool_key_cookie = $1;
		}
	if (lc($h->[0]) eq 'set-cookie' &&
	   $h->[1] =~ /Typo3InstallTool=([^;]+)/i) {
		$installtool_cookie = $1;
		}
	}
}

1;

