
# script_smf_desc()
sub script_smf_desc
{
return "Simple Machines Forum";
}

sub script_smf_uses
{
return ( "php" );
}

sub script_smf_longdesc
{
return "Simple Machines Forum (SMF) is a free, professional grade software package that allows you to set up your own online community within minutes."
}

# script_smf_versions()
sub script_smf_versions
{
return ( "2.0.7" );
}

sub script_smf_category
{
return "Community";
}

sub script_smf_php_vers
{
return ( 4, 5 );
}

sub script_smf_php_modules
{
return ("mysql");
}

sub script_smf_dbs
{
return ("mysql");
}

# script_smf_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Simple Machines Forum
sub script_smf_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Simple Machines Forum tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);

	# Show a warning if there are any extra packages
	local @pkgs = glob("$upgrade->{'opts'}->{'dir'}/Packages/backups/*.tar.gz");
	if (@pkgs) {
		$rv .= &ui_table_row(undef,
			"Warning - Virtualmin has detected ".scalar(@pkgs).
			" additional SMF packages, whose file changes will".
			" be overwritten if SMF is upgraded.", 2);
		}
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Simple Machines Forum tables",
		     &ui_database_select("db", undef, \@dbs, $d, "smf"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("smf", $d), 30, "At top level"));
	}
return $rv;
}

# script_smf_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_smf_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_smf_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_smf_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "Simple Machines Forum appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "smf_");
$clash && return "Simple Machines Forum appears to be already using the selected database (table $clash)";
return undef;
}

# script_smf_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Simple Machines Forum, each of which is a hash ref
# containing a name, filename and URL
sub script_smf_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $dver = $ver;
$dver =~ s/\./-/g;
local $suffix = $upgrade ? "upgrade" : "install";
local @files = ( { 'name' => "source",
	   'file' => "smf_${dver}_${suffix}.zip",
	   'url' => "http://download.simplemachines.org/index.php/smf_${dver}_${suffix}.tar.gz" } );
return @files;
}

sub script_smf_commands
{
return ("unzip");
}

# script_smf_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Simple Machines Forum, and returns either 1 and an
# informational message, or 0 and an error
sub script_smf_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, undef);
$err && return (0, "Failed to extract source : $err");

# Make needed files writable
foreach my $f ("attachments", "avatars", "Packages", "Packages/installed.list",
	       "Smileys", "Themes", "agreement.txt", "Settings.php",
	       "Settings_bak.php") {
	&make_file_php_writable($d, $opts->{'dir'}."/".$f, 1);
	}

local $url = &script_path_url($d, $opts);
if (!$upgrade) {
	# Make directory writable
	&make_file_php_writable($d, $opts->{'dir'}, 1);

	# Post to the DB setup page
	local $nsurl = $url;
	$nsurl =~ s/\/$//;
	local @params = (
		[ "db_type", $dbtype ],
		[ "db_server", $dbhost ],
		[ "db_user", $dbuser ],
		[ "db_passwd", $dbpass ],
		[ "db_name", $dbname ],
		[ "db_prefix", "smf_" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php?step=2";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Simple Machines Forum database configuration failed : $ierror");
		}

	# Post to the forum setup page
	local @params = (
		[ "mbname", $d->{'owner'} ],
		[ "boardurl", $nsurl ],
		[ "dbsession", 1 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php?step=3";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Simple Machines Forum board configuration failed : $ierror");
		}

	# Post to the user creation page
	local @params = (
		[ "username", $domuser ],
		[ "password1", $dompass ],
		[ "password2", $dompass ],
		[ "email", $d->{'emailto_addr'} ],
		[ "password3", $dbpass ],
		[ "contbutt", "Continue" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php?step=5";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Simple Machines Forum user setup failed : $ierror");
		}

	# Delete install.php
	&unlink_file_as_domain_user($d, "$opts->{'dir'}/install.php");
	}

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $upgradeurl = $url."upgrade.php";
if ($upgrade) {
	return (1, "Initial Simple Machines Forum upgrade complete. Go to <a target=_blank href='$upgradeurl'>$upgradeurl</a> to complete the upgrade process.", "Under $rp", $url, $domuser, $dompass);
	}
else {
	return (1, "Initial Simple Machines Forum installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp", $url, $domuser, $dompass);
	}
}

# script_smf_uninstall(&domain, version, &opts)
# Un-installs a Simple Machines Forum installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_smf_uninstall
{
local ($d, $version, $opts) = @_;

# Remove smf tables from the database
&cleanup_script_database($d, $opts->{'db'}, "smf_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted Simple Machines Forum directory and tables.");
}

# script_smf_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_smf_latest
{
return ( "http://download.simplemachines.org/index.php",
	 "Download\\s+SMF\\s+([0-9\\.]+)<" );
}

sub script_smf_site
{
return 'http://www.simplemachines.org/';
}

sub script_smf_passmode
{
return 1;
}

1;

