
# script_pommo_desc()
sub script_pommo_desc
{
return "poMMo";
}

sub script_pommo_uses
{
return ( "php" );
}

sub script_pommo_longdesc
{
return "poMMo is versatile mass mailing software. It can be used to add a mailing list to your Web site or to organize stand alone mailings.";
}

# script_pommo_versions()
sub script_pommo_versions
{
return ( "aardvarkPR16.1" );
}

sub script_pommo_version_desc
{
local ($ver) = @_;
$ver =~ s/^[a-z]+//;
return $ver;
}

sub script_pommo_category
{
return "Email";
}

sub script_pommo_php_vers
{
return ( 4, 5 );
}

sub script_pommo_php_modules
{
return ( "mysql" );
}

sub script_pommo_dbs
{
return ("mysql");
}

# script_pommo_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing poMMo
sub script_pommo_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for poMMo tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for poMMo tables",
		     &ui_database_select("db", undef, \@dbs, $d, "pommo"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("pommo", $d), 30, "At top level"));
	$rv .= &ui_table_row("Initial mailing list name",
	     &ui_opt_textbox("list", undef, 40, "Choose automatically"));
	}
return $rv;
}

# script_pommo_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_pommo_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'list' => $in->{'list_def'} ? undef : $in->{'list'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_pommo_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_pommo_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "poMMo appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "pommo_");
$clash && return "poMMo appears to be already using the selected database (table $clash)";
return undef;
}

# script_pommo_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by poMMo, each of which is a hash ref
# containing a name, filename and URL
sub script_pommo_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "poMMo-$ver.zip",
	   'url' => "http://internap.dl.sourceforge.net/sourceforge/pommo/poMMo-$ver.zip" } );
return @files;
}

sub script_pommo_commands
{
return ("unzip");
}

# script_pommo_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs poMMo, and returns either 1 and an informational
# message, or 0 and an error
sub script_pommo_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "pommo");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
local $longpass = $dompass;
local $passmsg;
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Copy over sample config file
	local $scfile = "$opts->{'dir'}/config.sample.php";
	&copy_source_dest_as_domain_user($d, $scfile, $cfile);
	&make_file_php_writable($d, $cfile);

	# Update the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\[db_hostname\]\s*=/) {
			$l = "[db_hostname] = \"$dbhost\";";
			}
		if ($l =~ /^\[db_username\]\s*=/) {
			$l = "[db_username] = \"$dbuser\";";
			}
		if ($l =~ /^\[db_password\]\s*=/) {
			$l = "[db_password] = \"".&php_quotemeta($dbpass)."\";";
			}
		if ($l =~ /^\[db_database\]\s*=/) {
			$l = "[db_database] = \"$dbname\";";
			}
		if ($l =~ /^\[db_prefix\]\s*=/) {
			$l = "[db_prefix] = \"pommo_\";";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Make the cache directory writable
	&make_file_php_writable($d, "$opts->{'dir'}/cache");

	# Make a HTTP call to get the cookie. Sometimes this fails the first
	# time around!!
	$pommo_session_cookie = undef;
	while(1) {
		local ($dummy, $dummyerr);
		&get_http_connection(
			$d, $opts->{'path'}."/install/install.php", \$dummy,
			\$dummyerr, \&pommo_cookie_callback, 0, undef, undef,
			undef, 0, 1);
		last if ($dummy !~ /Smarty\s+error/i);
		}
	$pommo_session_cookie || 
		return (-1, "Failed to get session cookie from install page");

	# Trigger the installation PHP script
	local @params = (
		[ "list_name", $opts->{'list'} ||
			       $d->{'owner'}." mailing list" ],
		[ "site_name", $d->{'owner'} ],
		[ "site_url", "http://www.$d->{'dom'}/" ],
		[ "admin_password", $dompass ],
		[ "admin_password2", $dompass ],
		[ "admin_email", $d->{'emailto_addr'} ],
		[ "installerooni", "Install" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror,
		      { 'Cookie' => 'PHPSESSID='.$pommo_session_cookie });
	if ($ierror) {
		return (-1, "poMMo post-install configuration failed : $ierror");
		}
	elsif ($iout !~ /Installation\s+Complete/i) {
		return (-1, "poMMo post-install configuration failed");
		}
	}

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial poMMo installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp", $url, "admin", $dompass );
}

# script_pommo_uninstall(&domain, version, &opts)
# Un-installs a poMMo installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_pommo_uninstall
{
local ($d, $version, $opts) = @_;

# Remove pommo tables from the database
&cleanup_script_database($d, $opts->{'db'}, "pommo_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted poMMo directory and tables.");
}

# script_pommo_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_pommo_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("pommo", "poMMo-([a-zA-Z0-9\\.]+)\\.zip");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_pommo_site
{
return 'http://pommo.org/';
}

sub script_pommo_passmode
{
return 2;
}

sub pommo_cookie_callback
{
if ($WebminCore::header{'set-cookie'} =~ /PHPSESSID=([^ ;]+)/) {
	$pommo_session_cookie = $1;
	}
}

1;

