
# script_phpsupport_desc()
sub script_phpsupport_desc
{
return "PHP Support Tickets";
}

sub script_phpsupport_uses
{
return ( "php" );
}

sub script_phpsupport_longdesc
{
return "A feature-rich PHP helpdesk.";
}

# script_phpsupport_versions()
sub script_phpsupport_versions
{
return ( "2.2", "2.0" );
}

sub script_phpsupport_abandoned
{
return 2;
}

sub script_phpsupport_category
{
return "Helpdesk";
}

sub script_phpsupport_php_vers
{
return ( 5 );
}

sub script_phpsupport_php_modules
{
return ("mysql");
}

sub script_phpsupport_dbs
{
return ("mysql");
}

# script_phpsupport_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHPSupport
sub script_phpsupport_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHP Support Tickets tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for PHP Support Tickets tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpsupport"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("support", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpsupport_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpsupport_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpsupport_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpsupport_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "PHP Support Tickets appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "tickets_.*");
$clash && return "PHP Support Tickets appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpsupport_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHPSupport, each of which is a hash ref
# containing a name, filename and URL
sub script_phpsupport_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "PHP_S_Tickets_v$ver.zip",
	   'virtualmin' => 1,
	   'nocheck' => 1,
	   'url' => "http://www.phpsupporttickets.com/modules/phpsupporttickets.com/dist/free/PHP_Support_Tickets_v$ver.zip" } );
return @files;
}

sub script_phpsupport_commands
{
return ("unzip");
}

# script_phpsupport_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHP Support Tickets, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpsupport_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Create the target dir
if (!-d $opts->{'dir'}) {
	local $out = &run_as_domain_user(
		$d, "mkdir -p ".quotemeta($opts->{'dir'})." 2>&1");
	if ($? || !-d $opts->{'dir'}) {
		return "Failed to create target directory : ".
		       "<tt>".&html_escape($out)."</tt>";
		}
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d);
$err && return (0, "Failed to extract source : $err");
if (-r "$temp/tickets/include/config.php") {
	$out = &run_as_domain_user($d, "cp -rp ".quotemeta($temp)."/tickets/* ".
				       quotemeta($opts->{'dir'}));
	}
else {
	$out = &run_as_domain_user($d,
		"cp -rp ".quotemeta($temp)."/phpst_$ver/* ".
		quotemeta($opts->{'dir'}));
	}
return (0, "Failed to copy source : <pre>".&html_escape($out)."</pre>") if ($?);

local $url = &script_path_url($d, $opts);
if ($ver >= 2.2) {
	# Version 2.2 creates the config file dynamically, based on a form
	local $params =
		"index_page=".&urlize("index.php?")."&".
		"phpst_page=&".
		"base_url=".&urlize($url)."&".
		"upload_absolute_path=".&urlize("$opts->{'dir'}/upload")."&".
		"upload_relative_path=".&urlize($url."upload/")."&".
		"mail_to=".&urlize($d->{'emailto_addr'})."&".
		"mail_name=".&urlize($d->{'owner'})."&".
		"mail_subject=".&urlize("Contact from Support Tickets")."&".
		"mail_method=smtp&".
		"smtp_socket_from=".&urlize($d->{'emailto_addr'})."&".
		"smtp_socket_from_name=".&urlize($d->{'owner'})."&".
		"smtp_socket_reply=".&urlize($d->{'emailto_addr'})."&".
		"smtp_socket_reply_name=".&urlize($d->{'owner'})."&".
		"smtp_host=localhost&".
		"smtp_auth=0&".
		"smtp_user=".&urlize($d->{'user'})."&".
		"smtp_pass=".&urlize($d->{'pass'})."&".
		"admin_user=".&urlize($domuser)."&".
		"admin_pass=".&urlize($dompass)."&".
		"admin_pass_repeat=".&urlize($dompass)."&".
		"admin_email=".&urlize($d->{'emailto_addr'})."&".
		"db_host=".&urlize($dbhost)."&".
		"db_user=".&urlize($dbuser)."&".
		"db_pass=".&urlize($dbpass)."&".
		"db_type=mysql&".
		"db_data=".&urlize($dbname)."&".
		"prefix=tickets_&".
		"users_table=users&".
		"users_table_id=id&".
		"users_table_user=username&".
		"users_table_pass=pass&".
		"users_table_name=name&".
		"users_table_email=email&".
		"users_table_timestamp=timestamp&".
		"users_table_admin=admin&".
		"button=Submit";
	local ($err, $out);
	&post_http_connection($d, "$opts->{'path'}/install/index.php", $params,
			      \$out, \$err);
	# Ignore the error, as we get a 500 even when it works!
	#$err && return (-1, "Failed to call setup URL : $err");
	}
else {
	local $cfile = "$opts->{'dir'}/include/config.php";
	$cfile = "$opts->{'dir'}/config.php" if (!-r $cfile);
	-r $cfile || return (0, "Failed to copy source : <tt>$out</tt>.");

	# Update the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	local $l;
	local $qowner = &php_quotemeta($d->{'owner'});
	foreach $l (@$lref) {
		# For versions 2.0 and below
		if ($l =~ /^\s*\$user\s*=/) {
			$l = "\$user = '$dbuser';";
			}
		if ($l =~ /^\s*\$pass\s*=/) {
			$l = "\$pass = '".&php_quotemeta($dbpass)."';";
			}
		if ($l =~ /^\s*\$data\s*=/) {
			$l = "\$data = '$dbname';";
			}
		if ($l =~ /^\s*\$host\s*=/) {
			$l = "\$host = '$dbhost';";
			}
		if ($l =~ /^\s*\$socketfrom\s*=/) {
			$l = "\$socketfrom = '$d->{'emailto_addr'}';";
			}
		if ($l =~ /^\s*\$socketfromname\s*=/) {
			$l = "\$socketfromname = '$qowner';";
			}
		if ($l =~ /^\s*\$sockethost\s*=/) {
			$l = "\$sockethost = 'localhost';";
			}

		# For versions 2.1+
		if ($l =~ /define\('PHPST_PATH'/i) {
			$l = "define('PHPST_PATH', '$opts->{'dir'}/');";
			}
		if ($l =~ /define\('BASE_URL'/i) {
			$l = "DEFINE('BASE_URL', '$url');";
			}
		if ($l =~ /define\('PHPST_MAIL_TO'/i) {
			$l = "define('PHPST_MAIL_TO', '$d->{'emailto_addr'}');";
			}
		if ($l =~ /define\('PHPST_MAIL_NAME'/i) {
			$l = "define('PHPST_MAIL_NAME', '$d->{'subject'}');";
			}
		if ($l =~ /DEFINE\('DB_HOST'/i) {
			$l = "DEFINE('DB_HOST', '$dbhost');";
			}
		if ($l =~ /DEFINE\('DB_USER'/i) {
			$l = "DEFINE('DB_USER', '$dbuser');";
			}
		if ($l =~ /DEFINE\('DB_PASS'/i) {
			$l = "DEFINE('DB_PASS', '".
			     &php_quotemeta($dbpass)."');";
			}
		if ($l =~ /DEFINE\('DB_DATA'/i) {
			$l = "DEFINE('DB_DATA', '$dbname');";
			}
		if ($l =~ /define\('PHPST_MAIL_SOCKETFROM'/i) {
			$l = "define('PHPST_MAIL_SOCKETFROM', '$d->{'emailto_addr'}');";
			}
		if ($l =~ /define\('PHPST_MAIL_SOCKETFROMNAME'/i) {
			$l = "define('PHPST_MAIL_SOCKETFROMNAME', '$qowner');";
			}
		if ($l =~ /define\('PHPST_MAIL_SOCKETREPLY'/i) {
			$l = "define('PHPST_MAIL_SOCKETREPLY', '$d->{'emailto_addr'}');";
			}
		if ($l =~ /define\('PHPST_MAIL_SOCKETREPLYNAME'/i) {
			$l = "define('PHPST_MAIL_SOCKETREPLYNAME', '$qowner');";
			}
		if ($l =~ /define\('PHPST_MAIL_SOCKETHOST'/i) {
			$l = "define('PHPST_MAIL_SOCKETHOST', 'localhost');";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	if (!$upgrade) {
		# Run the SQL setup script
		local $sqlfile = "$opts->{'dir'}/support_tickets.sql";
		local $lref = &read_file_lines_as_domain_user($d, $sqlfile);
		foreach my $l (@$lref) {
			if ($l =~ /insert\s+into\s+`tickets_users`\s+values/i) {
				$l =~ s/'administrator'/'$domuser'/g;
				$l =~ s/'password'/'$dompass'/g;
				$l =~ s/'email\@yourdomain.com'/'$d->{'emailto_addr'}'/g;
				}
			}
		&flush_file_lines_as_domain_user($d, $sqlfile);
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile,
						       $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : ".
				  "<tt>$out</tt>.");
		}
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "PHP Support Tickets installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_phpsupport_uninstall(&domain, version, &opts)
# Un-installs a PHPSupport installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpsupport_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all tickets_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "tickets_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "PHP Support Tickets directory and tables deleted.");
}

# script_phpsupport_latest()
# Returns a URL and regular expression or callback func to get the version
# Disabled cause the download page is broken!
#sub script_phpsupport_latest
#{
#local ($ver) = @_;
#if ($ver > 2) {
#	return ( "http://www.phpsupporttickets.com/index.php?p=downloads",
#		 "PHP_S_Tickets_v([0-9\\.]+)\\.zip" );
#	}
#else {
#	return ( );
#	}
#}

sub script_phpsupport_site
{
return 'http://www.phpsupporttickets.com/';
}

sub script_phpsupport_passmode
{
return 1;
}

1;

