
# script_phpnuke_desc()
sub script_phpnuke_desc
{
return "PHP-Nuke";
}

sub script_phpnuke_uses
{
return ( "php" );
}

sub script_phpnuke_longdesc
{
return "A content management and portal solution featuring web-based administration, surveys, customizable blocks, modules and themes with multilanguage support.";
}

# script_phpnuke_versions()
sub script_phpnuke_versions
{
return ( "8.3.2", "6.0", "5.0" );
}

sub script_phpnuke_category
{
return "Content Management System";
}

sub script_phpnuke_php_vers
{
return ( 4, 5 );
}

sub script_phpnuke_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phpnuke_dbs
{
local ($d, $ver) = @_;
if ($ver >= 6.0) {
	return ("mysql", "postgres");
	}
else {
	return ("mysql");
	}
}

# script_phpnuke_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_phpnuke_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHP-Nuke tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d,
			$ver < 6.0 ? [ "mysql" ] : [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for PHP-Nuke tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpnuke"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpnuke", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpnuke_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpnuke_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpnuke_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpnuke_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "PHP-Nuke appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "nuke_.*");
$clash && return "PHP-Nuke appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpnuke_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_phpnuke_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $ext = $ver >= 6 ? "zip" : "tar.gz";
local @files = ( { 'name' => "source",
	   'file' => "PHP-Nuke-$ver.$ext",
	   'url' => $ver >= 8 ?
		"http://bitbucket.org/phpnuke/phpnuke/get/988b71c099f0.zip" :
		"http://phpnuke.org/files/PHP-Nuke-$ver.$ext" } );
if ($opts->{'db'} =~ /^postgres/) {
	# Need pg_nuke.sql too
	push(@files, { 'name' => 'pg_nuke',
		       'file' => 'pg_nuke.sql' });
	}
return @files;
}

sub script_phpnuke_commands
{
return ("unzip");
}

# script_phpnuke_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHP-Nuke, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpnuke_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "MySQL" : "PostgreSQL";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
		     $opts->{'dir'}, $ver >= 8 ? "phpnuke*/html" : "html");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/config.php";

# Update database details in config.php
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$dbuname\s*=/) { $l = "\$dbuname = \"$dbuser\";" }
	if ($l =~ /^\$dbpass\s*=/) { $l = "\$dbpass = \"".
					  &php_quotemeta($dbpass)."\";" }
	if ($l =~ /^\$dbname\s*=/) { $l = "\$dbname = \"$dbname\";" }
	if ($l =~ /^\$dbhost\s*=/) { $l = "\$dbhost = \"$dbhost\";" }
	if ($l =~ /^\$dbtype\s*=/) { $l = "\$dbtype = \"$dbphptype\";" }
	}
&flush_file_lines_as_domain_user($d, $cfile);

if ($upgrade) {
	# When upgrading, the database is OK already .. but we need to run
	# the upgrade PHP script
	local $oldvn = $upgrade->{'version'};
	local $newvn = $version;
	$oldvn =~ s/\.//;
	$newvn =~ s/\.//;
	local $upfile = "$temp/upgrades/upgrade$oldvn-$newvn.php";
	if ($ver < 8.0) {
		-r $upfile || return (0, "Upgrade script for version $upgrade->{'version'} not found.");
		local $updest = "$opts->{'dir'}/upgrade$oldvn-$newvn.php";
		$out = &run_as_domain_user($d, "cp ".quotemeta($upfile)." ".
					       quotemeta($updest));
		local $error;
		&get_http_connection(
			$d, "$opts->{'path'}/upgrade$oldvn-$newvn.php",
			"/dev/null", \$error, undef, 0);
		$error && return (0, "Failed to run upgrade script : $error");
		}
	}
else {
	# Run the SQL setup script
	if ($dbtype eq "mysql") {
		local $sqlfile = $ver >= 8 ?
				"$opts->{'dir'}/install/sql/nuke.sql" :
				"$temp/sql/nuke.sql";
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");
		}
	else {
		local $sqlfile = $files->{'pg_nuke'};
		&require_postgres();
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script in $dbname : <tt>$out</tt>.");
		}
	}

local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "PHP-Nuke installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_phpnuke_uninstall(&domain, version, &opts)
# Un-installs a PHP-Nuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpnuke_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all nuke_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "nuke_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "PHP-Nuke directory and tables deleted.");
}

# script_phpnuke_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_phpnuke_latest
{
local ($ver) = @_;
if ($ver >= 6.5) {
	return ( "http://phpnuke.org/modules.php?name=Release",
		 "Version\\s+([0-9\\.]+)\\s+released" );
	}
return ( );
}

sub script_phpnuke_site
{
return 'http://phpnuke.org/';
}

1;

