
# script_phpbb_desc()
sub script_phpbb_desc
{
return "phpBB";
}

sub script_phpbb_uses
{
return ( "php" );
}

sub script_phpbb_longdesc
{
return "A high powered, fully scalable, and highly customizable Open Source bulletin board package.";
}

# script_phpbb_versions()
sub script_phpbb_versions
{
return ( "3.0.12" );
}

sub script_phpbb_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 3 && $sinfo->{'version'} < 3) {
	return 0;
	}
return 1;
}

sub script_phpbb_version_desc
{
local ($ver) = @_;
return $ver < 3 ? "$ver (Legacy)" : $ver;
}

sub script_phpbb_category
{
return "Community";
}

sub script_phpbb_php_vers
{
return ( 4, 5 );
}

sub script_phpbb_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phpbb_dbs
{
return ("mysql", "postgres");
}

# script_phpbb_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing phpBB
sub script_phpbb_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for phpBB tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for phpBB tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpbb"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpbb", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpbb_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpbb_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpbb_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpbb_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "phpBB appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpbb_");
$clash && return "phpBB appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpbb_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by phpBB, each of which is a hash ref
# containing a name, filename and URL
sub script_phpbb_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phpBB-$ver.zip",
	   'url' => "http://www.phpbb.com/files/release/phpBB-$ver.zip" } );
return @files;
}

sub script_phpbb_commands
{
return ("unzip");
}

# script_phpbb_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs phpBB, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpbb_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Don't allow 2 -> 3 upgrades yet
if ($upgrade && $version >= 3 && $upgrade->{'version'} < 3) {
	return (0, "phpBB upgrades from version 2 to 3 are not supported");
	}

if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $tardir = $ver >= 3 ? "phpBB3" : "phpBB2";
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, $tardir);
$err && return (0, "Failed to extract source : $err");

# Make cache writable
&make_file_php_writable($d, "$opts->{'dir'}/cache");

local $url = &script_path_url($d, $opts);
local $longpass = $dompass;
local $shortuser = $domuser;
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);

	# Call the database upgrade URL
	local ($uerr, $uout);
	&get_http_connection(
		$d, "$opts->{'path'}/install/database_update.php",
		\$uerr, \$uout, undef, 0, undef, undef, undef, 0, 1);
	}
elsif ($ver < 3) {
	# Version 2 install, which just uses a single form

	# Make config.php writable
	&make_file_php_writable($d, $cfile);

	# Trigger the installation PHP script
	local @params = (
		[ "lang", "english" ],
		[ "dbms", $dbtype eq "mysql" ? "mysql4" : "postgres" ],
		[ "upgrade", 0 ],
		[ "dbhost", $dbhost ],
		[ "dbname", $dbname ],
		[ "dbuser", $dbuser ],
		[ "dbpasswd", $dbpass ],
		[ "prefix", "phpbb_" ],
		[ "board_email", $d->{'emailto_addr'} ],
		[ "server_name", "www.".$d->{'dom'} ],
		[ "server_port", $d->{'web_port'} ],
		[ "script_path", $opts->{'path'}."/" ],
		[ "admin_name", $shortuser ],
		[ "admin_pass1", $dompass ],
		[ "admin_pass2", $dompass ],
		[ "install_step", 1 ],
		[ "current_lang", "english" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1,"phpBB post-install configuration failed : $ierror");
		}
	elsif ($iout !~ /Finish Installation/i) {
		return (-1,"phpBB post-install configuration failed");
		}

	# Delete the contrib and install directories
	$out = &run_as_domain_user($d, "rm -rf ".
			quotemeta("$opts->{'dir'}/contrib")." ".
			quotemeta("$opts->{'dir'}/install"));
	}
elsif ($ver >= 3) {
	# Version 3 install, which is multi-page :-(

	# Make config.php writable
	&make_file_php_writable($d, $cfile);

	# Create params for DB page
	local @params = (
		[ "dbms", $dbtype eq "mysql" ? "mysql" : "postgres" ],
		[ "dbhost", $dbhost ],
		[ "dbport", "" ],
		[ "dbname", $dbname ],
		[ "dbuser", $dbuser ],
		[ "dbpasswd", $dbpass ],
		[ "table_prefix", "phpbb_" ],
		[ "img_imagick", "/usr/bin" ],
		[ "language", "en" ],
		[ "testdb", "true" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php?mode=install&sub=database";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1,"phpBB database configuration failed : $ierror");
		}
	elsif ($iout !~ /Successful.*connection/i) {
		return (-1, "phpBB database configuration failed");
		}

	if (length($longpass) < 6) {
		# phpBB requires a 6-character password!
		$longpass .= "123456";
		}
	$opts->{'longpass'} = $longpass;
	if (length($shortuser) > 20) {
		# phpBB has a 20-character username limit
		$shortuser = substr($shortuser, 0, 20);
		}
	$opts->{'shortuser'} = $shortuser;

	# Add params for admin page
	push(@params, 
		[ "default_lang", "en" ],
		[ "admin_name", $shortuser ],
		[ "admin_pass1", $longpass ],
		[ "admin_pass2", $longpass ],
		[ "board_email1", $d->{'emailto_addr'} ],
		[ "board_email2", $d->{'emailto_addr'} ],
		[ "check", "true" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php?mode=install&sub=administrator";

	# Make an HTTP post to the installer page
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1,"phpBB administrator configuration failed : $ierror");
		}
	elsif ($iout !~ /Tests.*passed/i) {
		return (-1, "phpBB administrator configuration failed");
		}

	# Make the same post to the config file writer
	local $ipage = $opts->{'path'}."/install/index.php?mode=install&sub=config_file";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "phpBB configuration file failed : $ierror");
		}
	elsif ($iout !~ /has.*been.*written/) {
		return (-1, "phpBB configuration file failed");
		}

	# Add params for the advanced settings page
	push(@params,
		[ "email_enable", 1 ],
		[ "smtp_delivery", 1 ],
		[ "smtp_host", "localhost" ],
		[ "smtp_auth", "PLAIN" ],
		[ "smtp_user", $d->{'user'} ],
		[ "smtp_pass", $d->{'pass'} ],
		[ "cookie_secure", 0 ],
		[ "force_server_vars", 0 ],
		[ "server_protocol", "http://" ],
		[ "server_name", $d->{'dom'} ],
		[ "server_port", $d->{'web_port'} ],
		[ "script_path", $opts->{'path'} ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php?mode=install&sub=create_table";

	# Make an HTTP post to the advanced settings page
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "phpBB advanced configuration failed : $ierror");
		}
	elsif ($iout !~ /create.*and.*populated/) {
		return (-1, "phpBB advanced configuration failed");
		}

	# Make a post to the final page
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php?mode=install&sub=final";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "phpBB final configuration failed : $ierror");
		}
	}

if ($ver >= 3) {
	# Delete the install directory
	$out = &run_as_domain_user($d, "rm -rf ".
			quotemeta("$opts->{'dir'}/install"));
	}

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial phpBB installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp", $url, $shortuser, $longpass );
}

# script_phpbb_uninstall(&domain, version, &opts)
# Un-installs a phpBB installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpbb_uninstall
{
local ($d, $version, $opts) = @_;

# Remove phpbb tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpbb_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted phpBB directory and tables.");
}

# script_phpbb_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_phpbb_latest
{
return ( "http://www.phpbb.com/downloads/olympus.php?from=submenu",
	 "phpBB-([0-9\\.]+(-PL[0-9]+)?)\\.zip" );
}

sub script_phpbb_site
{
return 'http://www.phpbb.com/';
}

sub script_phpbb_passmode
{
return 1;
}

1;

