
# script_passwd_desc()
sub script_passwd_desc
{
return "Passwd";
}

sub script_passwd_uses
{
return ( "php", "horde" );
}

sub script_passwd_longdesc
{
return "Passwd is the Horde password changing application."
}

# script_passwd_versions()
sub script_passwd_versions
{
return ( "h3-3.1.3" );
}

sub script_passwd_category
{
return "Horde";
}

# script_passwd_depends(&domain, version)
sub script_passwd_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("Passwd requires that Horde be installed first") if (!$horde);

return ( );
}

# script_passwd_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_passwd_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
        local $odir = $horde->{'opts'}->{'dir'};
        $odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "passwd", 30));
	}
return $rv;
}

# script_passwd_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_passwd_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
        local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
        $path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'db' => $horde->{'opts'}->{'db'},
		 'horde' => 1 };
	}
}

# script_passwd_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_passwd_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Passwd appears to be already installed in the selected directory";
	}
return undef;
}

# script_passwd_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Passwd, each of which is a hash ref
# containing a name, filename and URL
sub script_passwd_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "passwd-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/passwd/passwd-$ver.tar.gz" } );
return @files;
}

sub script_passwd_commands
{
return ("tar", "gunzip");
}

# script_passwd_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Passwd, and returns either 1 and an informational
# message, or 0 and an error
sub script_passwd_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "passwd-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir);

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Passwd installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_passwd_uninstall(&domain, version, &opts)
# Un-installs a Passwd installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_passwd_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Passwd directory deleted.");
}

# script_passwd_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_passwd_latest
{
return ( "http://ftp.horde.org/pub/passwd/",
         "passwd-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_passwd_site
{
return 'http://www.horde.org/passwd/';
}

1;

