
# script_owncloud_desc()
sub script_owncloud_desc
{
return "ownCloud";
}

sub script_owncloud_uses
{
return ( "php" );
}

sub script_owncloud_longdesc
{
return "ownCloud gives you universal access to your files through a web interface or WebDAV";
}

# script_owncloud_versions()
sub script_owncloud_versions
{
return ( "6.0.3" );
}

sub script_owncloud_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($sinfo->{'version'} < 6 && $newver >= 6) {
	return 0;
	}
return 1;
}

sub script_owncloud_php_vers
{
return ( 5 );
}

sub script_owncloud_php_modules
{
return ("gd", "xml");
}

# script_owncloud_depends(&domain, version)
sub script_owncloud_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.3+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif ($phpv < 5.3) {
	push(@rv, "ownCloud requires PHP version 5.3 or later");
	}

return @rv;
}

# script_owncloud_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_owncloud_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("owncloud", $d), 30, "At top level"));
	}
return $rv;
}

# script_owncloud_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_owncloud_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_owncloud_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_owncloud_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "ownCloud appears to be already installed in the selected directory";
	}
return undef;
}

# script_owncloud_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_owncloud_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "owncloud-$ver.tar.bz2",
	   'url' => "http://download.owncloud.org/community/owncloud-${ver}.tar.bz2" } );
return @files;
}

sub script_owncloud_commands
{
return ("tar", "bunzip2");
}

# script_owncloud_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs ownCloud, and returns either 1 and an informational
# message, or 0 and an error
sub script_owncloud_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "owncloud", 0, 1);
$err && return (0, "Failed to extract source : $err");

# Make data dir writable
&make_file_php_writable($d, "$opts->{'dir'}/install/data");

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial ownCloud installation complete. Got to <a target=_blank href='$url'>$url</a> to ".($upgrade ? "complete the upgrade process." : "create the administration user."), "Under $rp using $dbphptype database $dbname", $url);
}

# script_owncloud_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_owncloud_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "ownCloud directory and tables deleted.");
}

# script_owncloud_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_owncloud_latest
{
return ( "http://owncloud.org/install/",
	 "owncloud-([0-9\\.]+[a-z]*)\\.tar\\.bz2" );
}

sub script_owncloud_site
{
return 'http://owncloud.org/';
}

sub script_owncloud_passmode
{
return 0;
}

1;

