
# script_nag_desc()
sub script_nag_desc
{
return "Nag";
}

sub script_nag_uses
{
return ( "php", "horde" );
}

sub script_nag_longdesc
{
return "Nag is the Horde task list application.  It stores todo items, things due later this week, etc.";
}

# script_nag_versions()
sub script_nag_versions
{
return ( "h3-2.3.7" );
}

# script_nag_depends(&domain, version)
sub script_nag_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("Nag requires that Horde be installed first") if (!$horde);

return ( );
}

sub script_nag_category
{
return "Horde";
}

# script_nag_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_nag_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
        local $odir = $horde->{'opts'}->{'dir'};
        $odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "nag", 30));
	}
return $rv;
}

# script_nag_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_nag_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
        local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
        $path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'db' => $horde->{'opts'}->{'db'},
		 'horde' => 1 };
	}
}

# script_nag_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_nag_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Nag appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "nag_.*");
$clash && return "Nag appears to be already using the selected database (table $clash)";
return undef;
}

# script_nag_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Nag, each of which is a hash ref
# containing a name, filename and URL
sub script_nag_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "nag-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/nag/nag-$ver.tar.gz" } );
return @files;
}

sub script_nag_commands
{
return ("tar", "gunzip");
}

# script_nag_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Nag, and returns either 1 and an informational
# message, or 0 and an error
sub script_nag_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "nag-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir, 1);

# Execute the SQL file
if (!$upgrade) {
	local ($dbtype, $dbname) = split(/_/, $horde->{'opts'}->{'db'}, 2);
	local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
	local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
	if ($dbtype eq "mysql") {
		&require_mysql();
		local $sqlfile = "$opts->{'dir'}/scripts/sql/nag.sql";
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}
	elsif ($dbtype eq "postgres") {
		&require_postgres();
		local $sqlfile = "$opts->{'dir'}/scripts/sql/nag.sql";
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Nag installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_nag_uninstall(&domain, version, &opts)
# Un-installs a Nag installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_nag_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove nag tables from the horde database
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
&cleanup_script_database($d, $horde->{'opts'}->{'db'}, "nag_");

return (1, "Nag directory and tables deleted.");
}

# script_nag_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_nag_latest
{
return ( "http://ftp.horde.org/pub/nag/",
         "nag-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_nag_site
{
return 'http://www.horde.org/nag/';
}

1;

