
# script_gbook_desc()
sub script_gbook_desc
{
return "Advanced Guestbook";
}

sub script_gbook_uses
{
return ( "php" );
}

sub script_gbook_longdesc
{
return "Advanced Guestbook is a PHP-based guestbook script.";
}

# script_gbook_versions()
sub script_gbook_versions
{
return ( "2.4.4" );
}

sub script_gbook_category
{
return "Guestbook";
}

sub script_gbook_php_vers
{
return ( 5 );
}

sub script_gbook_php_modules
{
return ("mysql");
}

sub script_gbook_dbs
{
return ("mysql");
}

# script_gbook_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_gbook_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Advanced Guestbook tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Advanced Guestbook tables",
		     &ui_database_select("db", undef, \@dbs, $d, "gbook"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("guestbook", $d), 30, "At top level"));
	}
return $rv;
}

# script_gbook_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_gbook_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_gbook_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_gbook_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/admin/config.inc.php") {
	return "Advanced Guestbook appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "book_.*");
$clash && return "Advanced Guestbook appears to be already using the selected database (table $clash)";
return undef;
}

# script_gbook_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_gbook_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "gbookphp-$ver.tar.gz",
	   'url' => "http://download.webmin.com/download/others/gbookphp-$ver.tar.gz" } );
return @files;
}

sub script_gbook_commands
{
return ("unzip");
}

# script_gbook_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Advanced Guestbook, and returns either 1 and an informational
# message, or 0 and an error
sub script_gbook_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "guestbook");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/admin/config.inc.php";

# Update the config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$GB_DB\["dbName"\]\s*=/) {
		$l = "\$GB_DB[\"dbName\"] = \"$dbname\";";
		}
	if ($l =~ /^\$GB_DB\["user"\]\s*=/) {
		$l = "\$GB_DB[\"user\"] = \"$dbuser\";";
		}
	if ($l =~ /^\$GB_DB\["pass"\]\s*=/) {
		$l = "\$GB_DB[\"pass\"] = \"".&php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\$GB_DB\["host"\]\s*=/) {
		$l = "\$GB_DB[\"host\"] = \"$dbhost\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Set file permissions
&set_permissions_as_domain_user($d, 0777, "$opts->{'dir'}/public");
&set_permissions_as_domain_user($d, 0777, "$opts->{'dir'}/tmp");

if (!$upgrade) {
	# Call the install URL
	local @params = (
		[ "db", $dbname ],
		[ "host", $dbhost ],
		[ "name", $dbuser ],
		[ "pass", $dbpass ],
		[ "gb_name", $domuser ],
		[ "gb_pass", $dompass ],
		[ "action", "Create table" ]
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Advanced Guestbook post-install configuration failed : $ierror");
		}
	elsif ($iout !~ /Tables\s+were\s+created/i) {
		return (-1, "Advanced Guestbook post-install configuration failed");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Advanced Guestbook installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_gbook_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_gbook_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all book_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "book_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Advanced Guestbook directory and tables deleted.");
}

#sub script_gbook_site
#{
#return 'http://www.proxy2.de/scripts.php';
#}

# script_gbook_latest(version)
# Returns a URL and regular expression or callback func to get the version
#sub script_gbook_latest
#{
#return ( "http://proxy2.de/scripts.php",
#	 "Advanced\\s+Guestbook\\s+([0-9\\.]+)" );
#}

sub script_gbook_abandoned
{
return 1;
}

sub script_gbook_passmode
{
return 1;
}

1;

