
# script_gallery_desc()
sub script_gallery_desc
{
return "Gallery";
}

sub script_gallery_uses
{
return ( "php" );
}

sub script_gallery_longdesc
{
return "Gallery is a web based software product that lets you manage your photos.";
}

# script_gallery_versions()
sub script_gallery_versions
{
return ( "3.0.9", "2.3.2" );
}

sub script_gallery_version_desc
{
local ($ver) = @_;
return $ver < 3 ? "$ver (Old)" : "$ver (Stable)";
}

sub script_gallery_category
{
return "Photos";
}

sub script_gallery_php_vers
{
return ( 5 );
}

# script_gallery_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_gallery_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("gallery", $d), 30, "At top level"));
	}
return $rv;
}

# script_gallery_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_gallery_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_gallery_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_gallery_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Gallery appears to be already installed in the selected directory";
	}
return undef;
}

# script_gallery_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Gallery, each of which is a hash ref
# containing a name, filename and URL
sub script_gallery_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $vfile = $ver >= 2.0 && $ver < 3 ? "$ver-full" : $ver;
local @files = ( { 'name' => "source",
	   'file' => "gallery-$vfile.zip",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/gallery/gallery-$vfile.zip" } );
return @files;
}

sub script_gallery_commands
{
return ("unzip");
}

# script_gallery_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Gallery, and returns either 1 and an informational
# message, or 0 and an error
sub script_gallery_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir and copy to target
local $subdir = &compare_versions($ver, 3) >= 0 ? "gallery3" :
		&compare_versions($ver, 2) >= 0 ? "gallery2" :
	        &compare_versions($ver, "1.5.8") >= 0 ? "gallery-$ver" :
			    "gallery";
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, $subdir);
$err && return (0, "Failed to extract source : $err");

# Create files for writing by webserver
&run_as_domain_user($d, "touch ".quotemeta("$opts->{'dir'}/.htaccess"));
&make_file_php_writable($d, "$opts->{'dir'}/.htaccess");
&run_as_domain_user($d, "touch ".quotemeta("$opts->{'dir'}/config.php"));
&make_file_php_writable($d, "$opts->{'dir'}/config.php");
&run_as_domain_user($d, "mkdir ".quotemeta("$opts->{'dir'}/albums"));
&make_file_php_writable($d, "$opts->{'dir'}/albums", 1);

# Return a URL for the user
local $userurl = &script_path_url($d, $opts);
local $url = $ver >= 2.0 ?
	$userurl."index.php" :
	$userurl."setup/index.php";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Go to <a target=_blank href='$url'>$url</a> to complete the Gallery installation process.", "Under $rp", $userurl);
}

# script_gallery_uninstall(&domain, version, &opts)
# Un-installs a Gallery installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_gallery_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Gallery directory deleted.");
}

# script_gallery_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_gallery_php_vars
{
return ( [ 'register_globals', 'Off' ] );
}

# script_gallery_check_latest()
sub script_gallery_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("gallery",
	$ver < 2 ? 'gallery-(1\\.[0-9\\.]+(-pl[0-9]+)?)\.zip' :
	$ver < 3 ? 'gallery-(2\\.[0-9\\.\-rc]+)-full\.zip' :
		   'gallery-(3\\.[0-9\\.\-rc]+)\.zip');
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_gallery_site
{
return 'http://galleryproject.org/';
}

1;

