
# script_formmail_desc()
sub script_formmail_desc
{
return "FormMail";
}

sub script_formmail_uses
{
return ( "perl", "cgi" );
}

sub script_formmail_longdesc
{
return "FormMail is a generic HTML form to e-mail gateway that parses the results of any form and sends them to the specified users.";
}

# script_formmail_versions()
sub script_formmail_versions
{
return ( "1.93" );
}

sub script_formmail_category
{
return "Email";
}

# script_formmail_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_formmail_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $cdir = &cgi_bin_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install location under <tt>$d->{'home'}</tt>",
		     &ui_textbox("dir", "$cdir/FormMail.pl", 30));
	}
return $rv;
}

# script_formmail_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_formmail_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation location";
	local $dir = "$d->{'home'}/$in{'dir'}";
	if (-r $dir) {
		return "FormMail or some other program already exists at the selected location.";
		}
	local $cdir = &cgi_bin_dir($d);
	local $hdir = &public_html_dir($d);
	local $path;
	if ($dir =~ /^\Q$cdir\E\/(.*)$/) {
		# Under /cgi-bin
		$path = "/cgi-bin/$1";
		}
	elsif ($dir =~ /^\Q$hdir\E\/(.*)$/) {
		# Under HTML dir
		$path = "/$1";
		}
	else {
		return "FormMail must be installed under the <tt>cgi-bin</tt> or <tt>public_html</tt> directories.";
		}
	return { 'dir' => $dir,
		 'path' => $path, };
	}
}

# script_formmail_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_formmail_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
return undef;
}

# script_formmail_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_formmail_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "formmail.tar",
	   'url' => "http://www.scriptarchive.com/scripts/formmail/formmail.tar" } );
return @files;
}

sub script_formmail_commands
{
return ("tar");
}

# script_formmail_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs FormMail, and returns either 1 and an informational
# message, or 0 and an error
sub script_formmail_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir
local $temp = &transname();
mkdir($temp, 0755);
chown($d->{'uid'}, $d->{'gid'}, $temp);
$out = &run_as_domain_user($d, "cd ".quotemeta($temp).
			       " && tar xf $files->{'source'}");
-r "$temp/formmail/FormMail.pl" ||
	return (0, "Failed to extract source : <tt>$out</tt>.");

# Copy file to target, and set permissions
$out = &run_as_domain_user($d, "cp -p ".quotemeta($temp)."/formmail/FormMail.pl ".quotemeta($opts->{'dir'}));
$out = &run_as_domain_user($d, "chmod 755 ".quotemeta($opts->{'dir'}));

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "FormMail can be accessed at <a target=_blank href='$url'>$url</a>.", "At $rp", $url);
}

# script_formmail_uninstall(&domain, version, &opts)
# Un-installs a FormMail installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_formmail_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
&is_under_directory($d->{'home'}, $opts->{'dir'}) ||
	return (0, "Invalid install directory $opts->{'dir'}");
local $out = &backquote_logged("rm -rf ".quotemeta($opts->{'dir'}));
$? && return (0, "Failed to delete files : <tt>$out</tt>");

return (1, "FormMail program deleted.");
}

1;

