
# script_flyspray_desc()
sub script_flyspray_desc
{
return "Flyspray";
}

sub script_flyspray_uses
{
return ( "php" );
}

sub script_flyspray_longdesc
{
return "Flyspray is an uncomplicated, web-based bug tracking system for assisting with software development.";
}

# script_flyspray_versions()
sub script_flyspray_versions
{
return ( "0.9.9.7" );
}

sub script_flyspray_category
{
return "Tracker";
}

sub script_flyspray_php_vers
{
return ( 5 );
}

sub script_flyspray_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $xmod = $phpver >= 5 ? "xml" : "domxml";
return $dbtype eq "mysql" ? ("mysql", $xmod) : ("pgsql", $xmod);
}

sub script_flyspray_dbs
{
return ("mysql", "postgres");
}

# script_flyspray_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_flyspray_php_vars
{
return ( [ 'safe_mode', 'Off' ],
	 [ 'file_uploads', 'On' ],
	 [ 'magic_quotes_gpc', 'Off' ],
	 [ 'register_globals', 'Off' ] );
}

# script_flyspray_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Flyspray
sub script_flyspray_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Flyspray tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Flyspray tables",
		     &ui_database_select("db", undef, \@dbs, $d, "flyspray"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("flyspray", $d), 30, "At top level"));
	}
return $rv;
}

# script_flyspray_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_flyspray_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_flyspray_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_flyspray_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "Flyspray appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "flyspray_.*");
$clash && return "Flyspray appears to be already using the selected database (table $clash)";
return undef;
}

# script_flyspray_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Flyspray, each of which is a hash ref
# containing a name, filename and URL
sub script_flyspray_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "flyspray-$ver.zip",
	   'url' => "http://flyspray.org/flyspray-$ver.zip" } );
return @files;
}

sub script_flyspray_commands
{
return ("unzip");
}

# script_flyspray_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Flyspray, and returns either 1 and an informational
# message, or 0 and an error
sub script_flyspray_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $ignore = 1;	# Always ignore for now
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, undef, 0, $ignore);
$err && return (0, "Failed to extract source : $err");

# Make important dirs writable
foreach my $sd ("cache", "attachments") {
	&make_file_php_writable($d, "$opts->{'dir'}/$sd");
	}
&make_file_php_writable($d, $opts->{'dir'}, 1);

local $url = &script_path_url($d, $opts);
if (!$upgrade) {
	$flyspray_session_cookie = undef;

	# Make an empty writable config file
	local $cfile = "$opts->{'dir'}/flyspray.conf.php";
	&open_tempfile_as_domain_user($d, CFILE, ">$cfile", 0, 1);
	&close_tempfile_as_domain_user($d, CFILE);
	&make_file_php_writable($d, $cfile);

	# First wizard page (intro)
	local @params = ( );
	local $err = &call_flyspray_wizard_page(\@params, "licence", $d, $opts);
	return (-1, "Flyspray wizard failed : $err") if ($err);

	# Second page (licence)
	local @params = ( [ "agreecheck", 1 ] );
	local $err = &call_flyspray_wizard_page(\@params, "database", $d,$opts);
	return (-1, "Flyspray wizard failed : $err") if ($err);

	# Third page (database)
	local @params = ( [ "db_hostname", $dbhost ],
			  [ "db_type", $dbtype eq "mysql" ? "mysql" : "pgsql" ],
			  [ "db_username", $dbuser ],
			  [ "db_password", $dbpass ],
			  [ "db_name", $dbname ],
			  [ "db_prefix", "flyspray_" ], );
	local $err = &call_flyspray_wizard_page(\@params, "administration", $d, $opts);
	return (-1, "Flyspray wizard failed : $err") if ($err);

	# Fourth page (admin user)
	local $longpass = $dompass;
	if (length($longpass) < 8) {
		# Flyspray requires an 8-character password!
		$longpass .= &random_password(8 - length($longpass));
		}
	$opts->{'longpass'} = $longpass;
	push(@params, [ "admin_email", $d->{'emailto_addr'} ],
		      [ "admin_username", $domuser ],
		      [ "admin_password", $longpass ],
		      [ "reminder_daemon", 1 ]);
	local $err = &call_flyspray_wizard_page(\@params, "complete", $d, $opts);
	return (-1, "Flyspray wizard failed : $err") if ($err);
	}
else {
	# Call the upgrade URL
        local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) }
				      ( [ 'upgrade', 1 ],
					[ 'upgrade', 'Perform Upgrade > >' ] ));
	local $ipage = $opts->{'path'}."/setup/upgrade.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	}

# Delete setup dir
&unlink_file_as_domain_user($d, "$opts->{'dir'}/setup");

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial Flyspray installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp using $dbtype database $dbname", $url, $domuser, $opts->{'longpass'});
}

# call_flyspray_wizard_page(&parameters, next-step, &domain, &opts)
sub call_flyspray_wizard_page
{
local ($params, $step, $d, $opts) = @_;
local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) }
			  ( @$params,
			    [ "action", $step ],
			    [ "next", "Next >>" ] ));
local $ipage = $opts->{'path'}."/setup/index.php";

local ($iout, $ierror);
local (%headers, %gotheaders);
if ($flyspray_session_cookie) {
	$headers{'Cookie'} = $flyspray_session_cookie;
	}
&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%headers,
		      \%gotheaders);
if (!$flyspray_session_cookie &&
    $gotheaders{'set-cookie'} =~ /(PHPSESSID=\S+);/) {
	$flyspray_session_cookie = $1;
	}
if ($ierror) {
	return $ierror;
	}
return undef;
}

# script_flyspray_uninstall(&domain, version, &opts)
# Un-installs a Flyspray installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_flyspray_uninstall
{
local ($d, $version, $opts) = @_;

# Remove flyspray tables from the database
&cleanup_script_database($d, $opts->{'db'}, "flyspray_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted Flyspray directory and tables.");
}

# script_flyspray_latest(version)
sub script_flyspray_latest
{
return ( "http://www.flyspray.org/download",
	 "flyspray-([0-9\\.]+).zip" );
}

sub script_flyspray_site
{
return 'http://www.flyspray.org/';
}

sub script_flyspray_passmode
{
return 1;
}

1;

