
# script_filecharger_desc()
sub script_filecharger_desc
{
return "Filecharger";
}

sub script_filecharger_uses
{
return ( "php" );
}

sub script_filecharger_longdesc
{
return "Filecharger is a self hosted, web-based file management solution for businesses, service providers, and individuals.";
}

# script_filecharger_versions()
sub script_filecharger_versions
{
return ( "1.0" );
}

sub script_filecharger_php_vers
{
return ( 5 );
}

sub script_filecharger_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
$mode eq "mod_php" &&
	push(@rv, "Filecharger requires that PHP scripts be executed fcgid or cgi modes, so that they can modify your files");
return @rv;
}

# script_filecharger_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_filecharger_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
		     &ui_textbox("dir", &substitute_scriptname_template("filecharger", $d), 30));
	}
return $rv;
}

# script_filecharger_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_filecharger_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => "/$in{'dir'}", };
	}
}

# script_filecharger_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_filecharger_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/admin.php") {
	return "Filecharger appears to be already installed in the selected directory";
	}
return undef;
}

# script_filecharger_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Twiki, each of which is a hash ref
# containing a name, filename and URL
sub script_filecharger_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "filecharger_$ver.zip",
	   'url' => "https://github.com/Zarel/filecharger/archive/master.zip" } );
return @files;
}

sub script_filecharger_commands
{
return ("unzip");
}

# script_filecharger_install(&domain, version, &opts, &files, &upgrade-info,
# 			   [user, pass])
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_filecharger_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.inc.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "filecharger-master");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Create config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	push(@$lref,
		'<?php',
		'$manual_install = TRUE;',
		'$fmurl = \''.$url.'\';',
		'$prepath = \''.&public_html_dir($d).'/\';',
		'$preurl = \'http://'.$d->{'dom'}.'/\';',
		'$presub = NULL;',
		'$loginfirst = TRUE;',
		'$isauth = TRUE;',
		'$allow_php = FALSE;',
		'$ext_jw_flv = NULL;',
		'$ext_codemirror = NULL;',
		'$ext_pclzip = NULL;',
		'$write_method = \'direct\';',
		'?>');
	&flush_file_lines_as_domain_user($d, $cfile);
	}
&make_file_php_writable($d, $cfile);
&make_file_php_writable($d, "$opts->{'dir'}/persist.inc.php");

local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Filecharger installation complete. It can be accessed at <a href='$url' target=_blank>$url</a>", "Under $rp", $url, "Admin", "");
}

# script_filecharger_uninstall(&domain, version, &opts)
# Un-installs an Filecharger installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_filecharger_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Filecharger directory deleted.");
}

sub script_filecharger_site
{
return "http://filecharger.com/";
}

1;

