
@dotproject_tables = ( "billingcode", "common_notes", "companies", "config", "config_list", "contacts", "custom_fields_lists", "custom_fields_struct", "custom_fields_values", "departments", "dpversion", "event_queue", "events", "files", "files_index", "forum_messages", "forum_visits", "forum_watch", "forums", "gacl_acl", "gacl_acl_sections", "gacl_acl_seq", "gacl_aco", "gacl_aco_map", "gacl_aco_sections", "gacl_aco_sections_seq", "gacl_aco_seq", "gacl_aro", "gacl_aro_groups", "gacl_aro_groups_id_seq", "gacl_aro_groups_map", "gacl_aro_map", "gacl_aro_sections", "gacl_aro_sections_seq", "gacl_aro_seq", "gacl_axo", "gacl_axo_groups", "gacl_axo_groups_id_seq", "gacl_axo_groups_map", "gacl_axo_map", "gacl_axo_sections", "gacl_axo_sections_seq", "gacl_axo_seq", "gacl_groups_aro_map", "gacl_groups_axo_map", "gacl_phpgacl", "modules", "permissions", "project_contacts", "project_departments", "projects", "roles", "sessions", "syskeys", "sysvals", "task_contacts", "task_departments", "task_dependencies", "task_log", "tasks", "tickets", "user_access_log", "user_events", "user_preferences", "user_roles", "user_task_pin", "user_tasks", "users", "file_folders", "dotpermissions" );

# script_dotproject_desc()
sub script_dotproject_desc
{
return "dotProject";
}

sub script_dotproject_uses
{
return ( "php" );
}

sub script_dotproject_longdesc
{
return "An open source project management tool.";
}

# script_dotproject_versions()
sub script_dotproject_versions
{
return ( "2.1.8" );
}

sub script_dotproject_category
{
return "Project Management";
}

sub script_dotproject_php_vers
{
return ( 5 );
}

sub script_dotproject_php_modules
{
return ("mysql");
}

sub script_dotproject_dbs
{
return ("mysql");
}

# script_dotproject_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_dotproject_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for dotProject tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for dotProject tables",
		     &ui_database_select("db", undef, \@dbs, $d, "dotproject"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("dotproject", $d), 30, "At top level"));
	}
return $rv;
}

# script_dotproject_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_dotproject_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_dotproject_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_dotproject_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "dotProject appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "billingcode");
$clash && return "dotProject appears to be already using the selected database (table $clash)";
return undef;
}

# script_dotproject_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_dotproject_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "dotproject_$ver.tar.gz",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/dotproject/dotproject-$ver.tar.gz" } );
return @files;
}

sub script_dotproject_commands
{
return ("tar", "gunzip");
}

# script_dotproject_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs dotProject, and returns either 1 and an informational
# message, or 0 and an error
sub script_dotproject_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
		     $opts->{'dir'}, "dotproject");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/includes/config.php";
local $cfileorig = "$opts->{'dir'}/includes/config-dist.php";

if (!$upgrade) {
	# Set permissions
	&make_file_php_writable($d, "$opts->{'dir'}/includes", 1);
	&make_file_php_writable($d, "$opts->{'dir'}/files", 1);
	&make_file_php_writable($d, "$opts->{'dir'}/files/temp", 1);

	# Run the setup script
	local @params = (
		[ "mode", "" ],
		[ "dbtype", "mysql" ],
		[ "dbhost", $dbhost ],
		[ "dbname", $dbname ],
	        [ "dbprefix", "" ],
		[ "dbuser", $dbuser ],
		[ "dbpass", $dbpass ],
		[ "do_db_cfg", " db & write cfg" ],
		);

	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/do_install_db.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "dotProject post-install configuration failed : $ierror");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial dotProject installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, "admin", "passwd");
}

# script_dotproject_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_dotproject_uninstall
{
local ($d, $version, $opts) = @_;

# Remove dotProject tables from the database
if ($opts->{'db'}) {
	&cleanup_script_database($d, $opts->{'db'}, \@dotproject_tables);
	}

# Take out the DB
if ($opts->{'db'} && $opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, $opts->{'db'} ? "dotProject directory and database deleted" :
			   "dotProject directory deleted. ".
			   "Database tables must be deleted manually.");
}

# script_dotproject_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_dotproject_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("dotproject", "dotproject[_-]([0-9\\.]+(\\-rc\\d+)?).tar.gz");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_dotproject_site
{
return 'http://www.dotproject.net/';
}

1;

