
# script_coppermine_desc()
sub script_coppermine_desc
{
return "Coppermine";
}

sub script_coppermine_uses
{
return ( "php" );
}

sub script_coppermine_longdesc
{
return "Coppermine is a multi-purpose fully-featured and integrated web picture gallery script written in PHP.";
}

# script_coppermine_versions()
sub script_coppermine_versions
{
return ( "1.5.28" );
}

sub script_coppermine_category
{
return "Photos";
}

sub script_coppermine_php_vers
{
return ( 5 );
}

sub script_coppermine_php_modules
{
return ("mysql", "gd");
}

sub script_coppermine_perl_modules
{
return ( "Digest::MD5" );
}

sub script_coppermine_dbs
{
return ("mysql");
}

# script_coppermine_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_coppermine_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Coppermine tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Coppermine tables",
		     &ui_database_select("db", undef, \@dbs, $d, "coppermine"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("coppermine", $d), 30, "At top level"));
	}
return $rv;
}

# script_coppermine_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_coppermine_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_coppermine_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_coppermine_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "Coppermine appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "CPG_.*");
$clash && return "Coppermine appears to be already using the selected database (table $clash)";
return undef;
}

# script_coppermine_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_coppermine_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "cpg$ver.zip",
	   'url' => "http://prdownloads.sourceforge.net/coppermine/files/cpg$ver.zip" } );
return @files;
}

sub script_coppermine_commands
{
return ("unzip");
}

# script_coppermine_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Coppermine, and returns either 1 and an informational
# message, or 0 and an error
sub script_coppermine_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $ver2 = $ver;
$ver2 =~ s/\.//g;
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "cpg*");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/include/config.inc.php";
local $cfileorig = "$opts->{'dir'}/include/config.inc.php.sample";

if (!-r $cfile) {
	# Copy and update config file
	&run_as_domain_user($d, "cp ".quotemeta($cfileorig)." ".
				      quotemeta($cfile));
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	local $l;
	foreach $l (@$lref) {
		if ($l =~ /^\$CONFIG\['dbuser'\]\s*=/) {
			$l = "\$CONFIG['dbuser'] = '$dbuser';";
			}
		if ($l =~ /^\$CONFIG\['dbpass'\]\s*=/) {
			$l = "\$CONFIG['dbpass'] = '".
			     &php_quotemeta($dbpass)."';";
			}
		if ($l =~ /^\$CONFIG\['dbname'\]\s*=/) {
			$l = "\$CONFIG['dbname'] = '$dbname';";
			}
		if ($l =~ /^\$CONFIG\['dbhost'\]\s*=/) {
			$l = "\$CONFIG['dbhost'] = '$dbhost';";
			}
		if ($l =~ /^\$CONFIG\['TABLE_PREFIX'\]\s*=/) {
			$l = "\$CONFIG['TABLE_PREFIX'] = 'CPG_';";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

# Set permissions
&make_file_php_writable($d, "$opts->{'dir'}/albums");
&make_file_php_writable($d, "$opts->{'dir'}/include");

local $url = &script_path_url($d, $opts);
if (!$upgrade) {
	# Run SQL setup scripts
	&require_mysql();
	foreach my $sf ("schema.sql", "basic.sql") {
		local $sqlfile = "$opts->{'dir'}/sql/$sf";
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}

	# Create initial user
	eval "use Digest::MD5";
	local $md5;
	if (!$@) {
		$md5 = Digest::MD5::md5_hex($dompass);
		}
	&mysql::execute_sql_logged($dbname, "insert into CPG_users (user_id, user_group, user_active, user_name, user_password) values (1, 1, 'YES', '$domuser', '$md5')");
	&mysql::execute_sql_logged($dbname, "update CPG_config set value = 'gd1' where name = 'thumb_method'");
	&mysql::execute_sql_logged($dbname, "update CPG_config set value = '$d->{'emailto_addr'}' where name = 'gallery_admin_email'");
	&mysql::execute_sql_logged($dbname, "update CPG_config set value = '$url' where name = 'ecards_more_pic_target'");
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $upmsg;
if ($upgrade) {
	local $upurl = $url."update.php";
	$upmsg = " Before it can be used, an upgrade must be performed at <a target=_blank href='$upurl'>$upurl</a>.";
	}
return (1, "Coppermine installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.".$upmsg, "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_coppermine_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_coppermine_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all cpg_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "CPG_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Coppermine directory and tables deleted.");
}

# script_coppermine_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_coppermine_latest
{
local ($ver) = @_;
return ( "http://coppermine-gallery.net/",
	 "cpg([0-9]+\\.[0-9\\.]+)\\.zip" );
}

sub script_coppermine_site
{
return 'http://coppermine-gallery.net/';
}

sub script_coppermine_passmode
{
return 1;
}

1;

