
# script_cgiemail_desc()
sub script_cgiemail_desc
{
return "cgiemail";
}

sub script_cgiemail_uses
{
return ( "perl", "cgi" );
}

sub script_cgiemail_longdesc
{
return "The purpose of cgiemail is to take the input of WWW forms and convert it to an e-mail format defined by the author of the WWW form.";
}

# script_cgiemail_versions()
sub script_cgiemail_versions
{
return ( "1.6" );
}

sub script_cgiemail_category
{
return "Email";
}

# script_cgiemail_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_cgiemail_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $cdir = &cgi_bin_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install location under <tt>$d->{'home'}</tt>",
		     &ui_textbox("dir", "$cdir/cgiemail", 30));
	}
return $rv;
}

# script_cgiemail_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_cgiemail_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	$in->{'dir'} =~ /\S/ && $in->{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation location";
	local $dir = "$d->{'home'}/$in->{'dir'}";
	local $cdir = &cgi_bin_dir($d);
	local $hdir = &public_html_dir($d);
	local $path;
	if ($dir =~ /^\Q$cdir\E\/(.*)$/) {
		# Under /cgi-bin
		$path = "/cgi-bin/$1";
		}
	elsif ($dir =~ /^\Q$hdir\E\/(.*)$/) {
		# Under HTML dir
		$path = "/$1";
		}
	else {
		return "cgiemail must be installed under the <tt>cgi-bin</tt> or <tt>public_html</tt> directories.";
		}
	return { 'dir' => $dir,
		 'path' => $path, };
	}
}

# script_cgiemail_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_cgiemail_check
{
local ($d, $ver, $opts, $upgrade) = @_;
if (-r $opts->{'dir'}) {
	return "cgiemail or some other program already exists at the selected location.";
	}
return undef;
}

# script_cgiemail_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_cgiemail_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "cgiemail-$ver.tar",
	   'url' => "http://web.mit.edu/wwwdev/cgiemail/cgiemail-$ver.tar" } );
return @files;
}

sub script_cgiemail_commands
{
return ("tar", "make", "gcc");
}

# script_cgiemail_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs cgiemail, and returns either 1 and an informational
# message, or 0 and an error
sub script_cgiemail_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir
local $temp = &transname();
mkdir($temp, 0755);
chown($d->{'uid'}, $d->{'gid'}, $temp);
$out = &run_as_domain_user($d, "cd ".quotemeta($temp).
			       " && tar xf $files->{'source'}");
-r "$temp/cgiemail-$ver/configure" ||
	return (0, "Failed to extract source : <tt>$out</tt>.");

# Compile in extracted directory
$out = &run_as_domain_user($d,
	"(cd ".quotemeta($temp)."/cgiemail-$ver && sh ./configure && make) 2>&1");
$? && return (0, "Failed to compile cgiemail source : <pre>$out</pre>");

# Copy file to target, and set permissions
$out = &run_as_domain_user($d, "cp -p ".quotemeta($temp)."/cgiemail-$ver/cgiemail ".quotemeta($opts->{'dir'}));
$out = &run_as_domain_user($d, "chmod 755 ".quotemeta($opts->{'dir'}));

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "cgiemail can be accessed at <a target=_blank href='$url'>$url</a>.", "At $rp", $url);
}

# script_cgiemail_uninstall(&domain, version, &opts)
# Un-installs a cgiemail installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_cgiemail_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
&is_under_directory($d->{'home'}, $opts->{'dir'}) ||
	return (0, "Invalid install directory $opts->{'dir'}");
local $out = &backquote_logged("rm -rf ".quotemeta($opts->{'dir'}));
$? && return (0, "Failed to delete files : <tt>$out</tt>");

return (1, "cgiemail program deleted.");
}

# script_cgiemail_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_cgiemail_latest
{
return ( "http://web.mit.edu/wwwdev/cgiemail/webmaster.html",
	 "cgiemail-([0-9\\.]+)\\.tar\\.gz" );
}

sub script_cgiemail_site
{
return 'http://web.mit.edu/wwwdev/cgiemail/webmaster.html';
}

1;

