
# script_aroundme_desc()
sub script_aroundme_desc
{
return "AROUNDMe";
}

sub script_aroundme_uses
{
return ( "php" );
}

sub script_aroundme_longdesc
{
return "AROUNDMe is the perfect solution for community builders wishing to bring together multiple mutual interest groups within a shared knowledge network."
}

# script_aroundme_versions()
sub script_aroundme_versions
{
return ( "0.6.9" );
}

sub script_aroundme_abandoned
{
return 2;
}

sub script_aroundme_category
{
return "Community";
}

sub script_aroundme_php_vers
{
return ( 4, 5 );
}

sub script_aroundme_php_modules
{
return ("mysql");
}

sub script_aroundme_dbs
{
return ("mysql");
}

# script_aroundme_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_aroundme_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for AROUNDMe tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for AROUNDMe tables",
		     &ui_database_select("db", undef, \@dbs, $d, "aroundme"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("aroundme", $d), 30, "At top level"));
	}
return $rv;
}

# script_aroundme_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_aroundme_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_aroundme_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_aroundme_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config/config_aroundme.inc.php") {
	return "AROUNDMe appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "am_.*");
$clash && return "AROUNDMe appears to be already using the selected database (table $clash)";
return undef;
}

# script_aroundme_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_aroundme_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $uver = $ver;
$uver =~ s/\./_/g;
local @files = ( { 'name' => "source",
	   'file' => "aroundme_$uver.zip",
	   'url' => "http://savannah.gnu.org/download/aroundme/aroundme_$uver.zip" } );
return @files;
}

sub script_aroundme_commands
{
return ("unzip");
}

# script_aroundme_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs AROUNDMe, and returns either 1 and an informational
# message, or 0 and an error
sub script_aroundme_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local $uver = $version;
$uver =~ s/\./_/g;

if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "aroundme_$uver/aroundme");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/config/config_aroundme.inc.php";

# Update the config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
local $url = &script_path_url($d, $opts);
foreach $l (@$lref) {
	if ($l =~ /^\$c_node\['db'\]\['driver'\]/) {
		$l = "\$c_node\['db'\]\['driver'\] = \"mysql\";";
		}
	if ($l =~ /^\$c_node\['db'\]\['host'\]/) {
		$l = "\$c_node\['db'\]\['host'\] = \"$dbhost\";";
		}
	if ($l =~ /^\$c_node\['db'\]\['user'\]/) {
		$l = "\$c_node\['db'\]\['user'\] = \"$dbuser\";";
		}
	if ($l =~ /^\$c_node\['db'\]\['pass'\]/) {
		$l = "\$c_node\['db'\]\['pass'\] = \"".
		     &php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\$c_node\['db'\]\['db'\]/) {
		$l = "\$c_node\['db'\]\['db'\] = \"$dbname\";";
		}
	if ($l =~ /^\$c_node\['mail'\]\['host'\]/) {
		$l = "\$c_node\['mail'\]\['host'\] = \"localhost\";";
		}
	if ($l =~ /^\$c_node\['mail'\]\['no_reply_address'\]/) {
		$l = "\$c_node\['mail'\]\['no_reply_address'\] = \"noreply\@$d->{'dom'}\";";
		}
	if ($l =~ /^\$c_node\['mail'\]\['default_address'\]/) {
		$l = "\$c_node\['mail'\]\['default_address'\] = \"$d->{'emailto_addr'}\";";
		}
	if ($l =~ /^\$c_node\['dir'\]\['www_path'\]/) {
		$l = "\$c_node\['dir'\]\['www_path'\] = \"$url\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

if (!$upgrade) {
	# Run SQL setup script
	&require_mysql();
	local $sqlfile = "$temp/aroundme_$uver/install/aroundme.sql";
	($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "AROUNDMe installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_aroundme_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_aroundme_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all am_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "am_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "AROUNDMe directory and tables deleted.");
}

# script_aroundme_latest()
# Returns a URL and regular expression or callback func to get the version
# Disabled as fetching the URL directly returns 404!
#sub script_aroundme_latest
#{
#return ( "http://www.barnraiser.org/aroundme/software_aroundme.php",
#	 "is version ([0-9\\.]+)" );
#}

sub script_aroundme_site
{
return 'http://www.barnraiser.org/aroundme/';
}

1;

